%%
%% This is file `Thesis.cls', based on 'ECSthesis.cls', by Steve R. Gunn
%% generated with the docstrip utility.
%%
%% Created by Steve R. Gunn, modified by Satvir Singh Sidhu: satvir15@gmail.com
%================================================================================

\NeedsTeXFormat{LaTeX2e}[1996/12/01]
\ProvidesClass{Thesis}
              [2007/22/02 v1.0
   LaTeX document class]
\def\baseclass{book}
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{\baseclass}}
\def\@checkoptions#1#2{
  \edef\@curroptions{\@ptionlist{\@currname.\@currext}}
  \@tempswafalse
  \@tfor\@this:=#2\do{
    \@expandtwoargs\in@{,\@this,}{,\@curroptions,}
    \ifin@ \@tempswatrue \@break@tfor \fi}
  \let\@this\@empty
  \if@tempswa \else \PassOptionsToClass{#1}{\baseclass}\fi
}
\@checkoptions{11pt}{{10pt}{11pt}{12pt}}
\PassOptionsToClass{a4paper}{\baseclass}
\ProcessOptions\relax
\LoadClass{\baseclass}
\newcommand\bhrule{\typeout{------------------------------------------------------------------------------}}

\newcommand\btypeout[1]{\bhrule\typeout{\space #1}\bhrule}
\def\monthyear{\ifcase\month\or
  January\or February\or March\or April\or May\or June\or
  July\or August\or September\or October\or November\or December\fi
  \space \number\year}
\usepackage{setspace}
\onehalfspacing
\setlength{\parindent}{0pt}
\setlength{\parskip}{2.0ex plus0.5ex minus0.2ex}
\usepackage{vmargin}
\setmarginsrb           { 1.1in}  % left margin
                        { 0.8in}  % top margin
                        { 1.1in}  % right margin
                        { 0.8in}  % bottom margin
                        {  20pt}  % head height
                        {0.25in}  % head sep
                        {   9pt}  % foot height
                        { 0.3in}  % foot sep
\raggedbottom
\setlength{\topskip}{1\topskip \@plus 5\p@}
\doublehyphendemerits=10000       % No consecutive line hyphens.
\brokenpenalty=10000              % No broken words across columns/pages.
\widowpenalty=9999                % Almost no widows at bottom of page.
\clubpenalty=9999                 % Almost no orphans at top of page.
\interfootnotelinepenalty=9999    % Almost never break footnotes.
\usepackage{fancyhdr}
\lhead[\rm\thepage]{\fancyplain{}{\sl{\rightmark}}}
\rhead[\fancyplain{}{\sl{\leftmark}}]{\rm\thepage}
\chead{}\lfoot{}\rfoot{}\cfoot{}
\pagestyle{fancy}
\renewcommand{\chaptermark}[1]{\btypeout{\thechapter\space #1}\markboth{\@chapapp\ \thechapter\ #1}{\@chapapp\ \thechapter\ #1}}
\renewcommand{\sectionmark}[1]{\markright{\thesection\ #1}}
\renewcommand{\subsectionmark}[1]{}
\def\cleardoublepage{\clearpage\if@twoside \ifodd\c@page\else
\hbox{}
\thispagestyle{empty}
\newpage
\if@twocolumn\hbox{}\newpage\fi\fi\fi}
\usepackage{amsmath,amsfonts,amssymb,amscd,amsthm,xspace}
\theoremstyle{plain}
\newtheorem{example}{Example}[chapter]
\newtheorem{theorem}{Theorem}[chapter]
\newtheorem{corollary}[theorem]{Corollary}
\newtheorem{lemma}[theorem]{Lemma}
\newtheorem{proposition}[theorem]{Proposition}
\newtheorem{axiom}[theorem]{Axiom}
\theoremstyle{definition}
\newtheorem{definition}[theorem]{Definition}
\theoremstyle{remark}
\newtheorem{remark}[theorem]{Remark}
\usepackage[centerlast,small,sc]{caption}
\setlength{\captionmargin}{20pt}
\newcommand{\fref}[1]{Figure~\ref{#1}}
\newcommand{\tref}[1]{Table~\ref{#1}}
\newcommand{\eref}[1]{Equation~\ref{#1}}
\newcommand{\cref}[1]{Chapter~\ref{#1}}
\newcommand{\sref}[1]{Section~\ref{#1}}
\newcommand{\aref}[1]{Appendix~\ref{#1}}
\renewcommand{\topfraction}{0.85}
\renewcommand{\bottomfraction}{.85}
\renewcommand{\textfraction}{0.1}
\renewcommand{\dbltopfraction}{.85}
\renewcommand{\floatpagefraction}{0.75}
\renewcommand{\dblfloatpagefraction}{.75}
\setcounter{topnumber}{9}
\setcounter{bottomnumber}{9}
\setcounter{totalnumber}{20}
\setcounter{dbltopnumber}{9}
\usepackage{graphicx}
\usepackage{epstopdf}
\usepackage[scriptsize]{subfigure}
\usepackage{booktabs}
\usepackage{rotating}
\usepackage{listings}
\usepackage{lstpatch}
\lstset{captionpos=b,
        frame=tb,
        basicstyle=\scriptsize\ttfamily,
        showstringspaces=false,
        keepspaces=true}
\lstdefinestyle{matlab} {
        language=Matlab,
        keywordstyle=\color{blue},
        commentstyle=\color[rgb]{0.13,0.55,0.13}\em,
        stringstyle=\color[rgb]{0.7,0,0} }
\usepackage[pdfpagemode={UseOutlines},bookmarks=true,bookmarksopen=true,
   bookmarksopenlevel=0,bookmarksnumbered=true,hypertexnames=false,
   colorlinks,linkcolor={black},citecolor={black},urlcolor={red},
   pdfstartview={FitH},unicode,breaklinks=true]{hyperref}
\pdfstringdefDisableCommands{
   \let\\\space
}

%========================DON'T CHANGE THIS TEXT==================================
\newcommand*{\Mainsupervisor}[1]{\def\msupname{#1}}
\newcommand*{\Cosupervisor}[1]{\def\csupname{#1}}
\newcommand*{\Registration}[1]{\def\regn{#1}}
\newcommand*{\university}[1]{\def\univname{#1}}
\newcommand*{\UNIVERSITY}[1]{\def\UNIVNAME{#1}}
\newcommand*{\department}[1]{\def\deptname{#1}}
\newcommand*{\DEPARTMENT}[1]{\def\DEPTNAME{#1}}
\newcommand*{\faculty}[1]{\def\facname{#1}}
\newcommand*{\FACULTY}[1]{\def\FACNAME{#1}}

\newcommand*{\addresses}[1]{\def\addressnames{#1}}
\newcommand*{\authors}[1]{\def\authornames{#1}}
\newcommand*{\degree}[1]{\def\degreename{#1}}
\newcommand*{\examiner}[1]{\def\examname{#1}}
\newcommand*{\keywords}[1]{\def\keywordnames{#1}}
\newcommand*{\subject}[1]{\def\subjectname{#1}}

\addresses   {}
\authors     {}
\examiner    {}
\degree      {}
\keywords    {}
\subject     {}

%================================================================================
%========================PERSONALIZE THIS TEXT===================================
%================================================================================
\Mainsupervisor {Professor Jasbir Singh Saini}
\Cosupervisor   {Professor Arun Khosla}
\university     {Maharishi Dayanand University, Rohtak}
\department     {Electronics \& Communication Engineering}
\DEPARTMENT     {ELECTRONICS \& COMMUNICATION ENGINEERING}
\faculty        {Faculty of Engineering \& Technology}
\FACULTY        {FACULTY OF ENGINEERING \& TECHNOLOGY}
\Registration   {Registration No.: 2005/Engg. \& Tech./07 Dated: 14.06.2005}
\UNIVERSITY     {\texorpdfstring{\href{http://www.mdu.ac.in}
                {MAHARSHI DAYANAND UNIVERSITY\\ROHTAK-124001 (HR) INDIA}}
                {MAHARSHI DAYANAND UNIVERSITY\\ROHTAK-124001 (HR) INDIA}}
%================================================================================
%========================PERSONALIZE THIS TEXT===================================rakesh1607@yahoo.co.in
%================================================================================
                
                
                
%========================TITLE PAGE 1===========================================
\renewcommand\maketitle{
  \btypeout{Title Page}
  \hypersetup{pdftitle={\@title}}
  \hypersetup{pdfsubject=\subjectname}
  \hypersetup{pdfauthor=\authornames}
  \hypersetup{pdfkeywords=\keywordnames}
  \thispagestyle{empty}
  \begin{titlepage}
    \let\footnotesize\small
    \let\footnoterule\relax
    \let \footnote \thanks
    \setcounter{footnote}{0}
    \begin{center}
      \setlength{\parskip}{0pt}
      \vfil\null
      {\Huge \bf \@title \par}
      \vskip 40\p@ 
      {\Huge \textbf{\authornames} \par}
      {\large [\regn] \par}
      \vskip 20\p@ 
      \begin{figure}[!h]
      \centering
      \includegraphics[width=2.5in]{LogoBlue}
      \end{figure}
      \vskip 10\p@ 
      {\large \textit{Thesis submitted in partial fulfillment of the requirements for the degree of Doctor of Philosophy 
      under the supervision of\\ {\textbf{\msupname}} and {\textbf{\csupname}}} \par}
      \vskip 40\p@ 
      {\Large \FACNAME \par}
      {\Large (\textit{\deptname}) \par}
      \vskip 20\p@ 
      {\LARGE\textbf{\UNIVNAME}\par}
      \vskip 30\p@ 
      {\Large \@date \par}
      \bigskip
    \end{center}
    \par
    \@thanks
    \vfil\null
  \cleardoublepage
%========================TITLE PAGE 2===========================================
  \thispagestyle{empty}
    \vskip 20\p@
    \begin{center}
      \setlength{\parskip}{0pt}
      {\Huge \bf \@title \par}
      \vskip 20\p@
      {\Huge \textbf{\authornames} \par}
      {\large [\regn] \par}
      \vskip 20\p@
      {\LARGE Under the Guidance of \par}
      {
      \begin{table}[h]
      \centering
          \includegraphics[width=\textwidth]{Supervisors.pdf}
      \end{table}
      }
      \vskip -30\p@
      \begin{figure}[!h]
      \centering
      \includegraphics[width=2.4in]{LogoBlue}
      \end{figure}
      {\large \textit{Thesis submitted in partial fulfillment of requirements for the degree of}\par}
      {\LARGE \emph{Doctor of Philosophy} \par}
      \vskip 20\p@ 
      {\Large \FACNAME \par}
      {\Large (\textit{\deptname}) \par}
      \vskip 20\p@ 
      {\LARGE\textbf{\UNIVNAME}\par}
      \vskip 20\p@ 
      {\Large \@date \par}
%      \bigskip
    \end{center}
    \par
    \@thanks
%    \vfil\null
  \end{titlepage}
  \setcounter{footnote}{0}%
  \global\let\thanks\relax
  \global\let\maketitle\relax
  \global\let\@thanks\@empty
  \global\let\@author\@empty
  \global\let\@date\@empty
  \global\let\@title\@empty
  \global\let\title\relax
  \global\let\author\relax
  \global\let\date\relax
  \global\let\and\relax
  \clearpage
}
\endinput

%=========================END - TITLE.CLS=======================================

